package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JButton;
import javax.swing.JLabel;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import net.miginfocom.swing.MigLayout;
import javax.swing.JComboBox;
import java.awt.Dimension;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;

public class MainAppWindow {

	private JFrame frmLikeARolling;
	private JPanel northPanel;
	private JPanel southPanel;
	private JPanel westPanel;
	private JPanel eastPanel;
	private JPanel centerPanel;
	private JMenuBar menuBar;
	private JMenu mnFile;
	private JMenu mnEdit;
	private JMenu mnHelp;
	private JButton btnStart;
	private JLabel lblLegendarySongs;
	private JLabel lblYear;
	private JLabel lblYearValue;
	private JButton btnSave;
	private JLabel lblSongs;
	private JComboBox songsComboBox;
	private JSplitPane splitPane;
	private JScrollPane leftScrollPane;
	private JScrollPane rightScrollPane;
	private JLabel lblPhoto;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmLikeARolling.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmLikeARolling = new JFrame();
		frmLikeARolling.setTitle("Like a Rolling Stone");
		frmLikeARolling.setBounds(100, 100, 450, 300);
		frmLikeARolling.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmLikeARolling.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmLikeARolling.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmLikeARolling.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmLikeARolling.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmLikeARolling.getContentPane().add(getCenterPanel(), BorderLayout.CENTER);
		frmLikeARolling.setJMenuBar(getMenuBar());
	}

	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.add(getBtnStart());
			northPanel.add(getLblLegendarySongs());
		}
		return northPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[]", "[]"));
		}
		return southPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setVisible(false);
			westPanel.setPreferredSize(new Dimension(100, 10));
			westPanel.setLayout(new MigLayout("", "[grow]", "[][]"));
			westPanel.add(getLblSongs(), "cell 0 0");
			westPanel.add(getSongsComboBox(), "cell 0 1,growx");
		}
		return westPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setVisible(false);
			eastPanel.setLayout(new MigLayout("", "[]", "[][][grow][]"));
			eastPanel.add(getLblYear(), "cell 0 0");
			eastPanel.add(getLblYearValue(), "cell 0 1");
			eastPanel.add(getBtnSave(), "cell 0 3");
		}
		return eastPanel;
	}
	private JPanel getCenterPanel() {
		if (centerPanel == null) {
			centerPanel = new JPanel();
			centerPanel.setVisible(false);
			centerPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
			centerPanel.add(getSplitPane(), "cell 0 0,grow");
		}
		return centerPanel;
	}
	private JMenuBar getMenuBar() {
		if (menuBar == null) {
			menuBar = new JMenuBar();
			menuBar.add(getMnFile());
			menuBar.add(getMnEdit());
			menuBar.add(getMnHelp());
		}
		return menuBar;
	}
	private JMenu getMnFile() {
		if (mnFile == null) {
			mnFile = new JMenu("File");
		}
		return mnFile;
	}
	private JMenu getMnEdit() {
		if (mnEdit == null) {
			mnEdit = new JMenu("Edit");
		}
		return mnEdit;
	}
	private JMenu getMnHelp() {
		if (mnHelp == null) {
			mnHelp = new JMenu("Help");
		}
		return mnHelp;
	}
	private JButton getBtnStart() {
		if (btnStart == null) {
			btnStart = new JButton("Start");
			btnStart.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					lblLegendarySongs.setVisible(true);
					btnStart.setVisible(false);
					southPanel.setVisible(true);
					eastPanel.setVisible(true);
					centerPanel.setVisible(true);
					westPanel.setVisible(true);
				}
			});
		}
		return btnStart;
	}
	private JLabel getLblLegendarySongs() {
		if (lblLegendarySongs == null) {
			lblLegendarySongs = new JLabel("Legendary songs");
			lblLegendarySongs.setVisible(false);
			lblLegendarySongs.setForeground(SystemColor.activeCaption);
			lblLegendarySongs.setFont(new Font("Tahoma", Font.BOLD, 13));
		}
		return lblLegendarySongs;
	}
	private JLabel getLblYear() {
		if (lblYear == null) {
			lblYear = new JLabel("Year");
		}
		return lblYear;
	}
	private JLabel getLblYearValue() {
		if (lblYearValue == null) {
			lblYearValue = new JLabel("");
		}
		return lblYearValue;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
		}
		return btnSave;
	}
	private JLabel getLblSongs() {
		if (lblSongs == null) {
			lblSongs = new JLabel("Songs");
		}
		return lblSongs;
	}
	private JComboBox getSongsComboBox() {
		if (songsComboBox == null) {
			songsComboBox = new JComboBox();
		}
		return songsComboBox;
	}
	private JSplitPane getSplitPane() {
		if (splitPane == null) {
			splitPane = new JSplitPane();
			splitPane.setLeftComponent(getLeftScrollPane());
			splitPane.setRightComponent(getRightScrollPane());
		}
		return splitPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLblPhoto());
		}
		return leftScrollPane;
	}
	private JScrollPane getRightScrollPane() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
		}
		return rightScrollPane;
	}
	private JLabel getLblPhoto() {
		if (lblPhoto == null) {
			lblPhoto = new JLabel("");
			lblPhoto.setIcon(new ImageIcon("C:\\Documents and Settings\\student1.SLUSAONICA-B009\\My Documents\\Like a Rolling Stone, 09.12.2015, E\\src\\resources\\Bob Dylan.jpeg"));
		}
		return lblPhoto;
	}
}
